 // This code, in its entirety, is Copyrighted Terry Smith, 2000.

import java.io.*;
import java.sql.*;
import java.math.BigDecimal;

import Utilities;
import EasyResultSet;

public class EasyStatement
{
   private String m_SQL;
   private Connection m_Connection;
   private PreparedStatement m_Statement;
   private int m_ColumnIndex = 1;

   public EasyStatement( Connection dbConnection )
   {
      m_Connection = dbConnection;
   }

   public String getSQL()
   {
      return m_SQL;
   }

   public void setSQL( String SQL ) throws java.sql.SQLException
   {
      m_SQL = SQL;
      m_ColumnIndex = 1;
      m_Statement = m_Connection.prepareStatement( m_SQL );
   }

   public int executeUpdate() throws java.sql.SQLException
   {
      return m_Statement.executeUpdate();
   }

   public EasyResultSet executeQuery() throws java.sql.SQLException
   {
      return new EasyResultSet( m_Statement );
   }

   public void close() throws java.sql.SQLException
   {
      if (m_Statement != null)
      {
         m_Statement.close();
      }
   }

   /**
   * Clears the current parameter values immediately. Resets
   * ColumnIndex to 1.
   */
   public void clearParameters() throws java.sql.SQLException
   {
      m_Statement.clearParameters();
      m_ColumnIndex = 1;
   }

   /**
   * Sets ColumnValue into the prepared statement for the CHAR data type.
   */
   public void write( String ColumnValue ) throws java.sql.SQLException
   {
      if ( ColumnValue == null )
      {
         m_Statement.setNull( m_ColumnIndex, java.sql.Types.CHAR );
      }
      else
      {
         ColumnValue = ColumnValue.trim();
         m_Statement.setString( m_ColumnIndex, ColumnValue );
      }

      m_ColumnIndex++;
   }

   /**
   * Sets ColumnValue into the prepared statement for a NUMBER column
   * used to stored an Integer value.
   */
   public void write( Integer ColumnValue ) throws java.sql.SQLException
   {
      if ( ColumnValue == null )
      {
         m_Statement.setNull( m_ColumnIndex, java.sql.Types.INTEGER );
      }
      else
      {
         m_Statement.setInt( m_ColumnIndex, ColumnValue.intValue() );
      }

      m_ColumnIndex++;
   }

   /**
   * Sets ColumnValue into the prepared statement for a NUMBER column
   * used to stored a Long value.
   */
   public void write( Long ColumnValue ) throws java.sql.SQLException
   {
      if ( ColumnValue == null )
      {
         m_Statement.setNull( m_ColumnIndex, java.sql.Types.NUMERIC );
      }
      else
      {
         m_Statement.setLong( m_ColumnIndex, ColumnValue.longValue() );
      }

      m_ColumnIndex++;
   }

   /**
   * Assumes that dates are being stored in the Oracle DATE date type or something
   * compatible.
   */
   public void write( java.util.Date ColumnValue ) throws java.sql.SQLException
   {
      if ( ColumnValue == null )
      {
         m_Statement.setNull( m_ColumnIndex, java.sql.Types.DATE );
      }
      else
      {
         Timestamp ColumnValueAsTimestamp = new Timestamp( ColumnValue.getTime() );
         m_Statement.setTimestamp( m_ColumnIndex, ColumnValueAsTimestamp );
      }

      m_ColumnIndex++;
   }

   /**
   * Writes the boolean value into the prepared statement as a string. Assumes you are
   * storing boolean values using the CHAR(1) data type as "T" or "F".
   */
   public void write( boolean ColumnValue ) throws java.sql.SQLException
   {
      String ColumnValueAsString = Utilities.booleanToString( ColumnValue );
      m_Statement.setString( m_ColumnIndex, ColumnValueAsString );

      m_ColumnIndex++;
   }
}
